﻿/**********************************************************

ADOBE SYSTEMS INCORPORATED 
Copyright 2005-2006 Adobe Systems Incorporated 
All Rights Reserved 

NOTICE:  Adobe permits you to use, modify, and 
distribute this file in accordance with the terms
of the Adobe license agreement accompanying it.  
If you have received this file from a source 
other than Adobe, then your use, modification,
or distribution of it requires the prior 
written permission of Adobe. 

*********************************************************/

//Author : Sanjay Kumar 

/* Resource definition of the New Flex Skin dialog */

var res =  

"dialog { orientation: 'column', alignChildren: 'right', \
            info: Group { orientation: 'column', alignChildren: 'left', \
                        text: 'Create Skins For:', \
                        skinType: Group { orientation: 'column', alignChildren: 'left', margins: 0, \
                                    rbtn1:  RadioButton {  text: 'Varios componentes Flex', assignmet: 'left'}, \
                                    rbtn2:  RadioButton {  text: 'Componentes específicos', assignmet: 'left'}, \
									componentsGroup: Group { alignChildren: 'right' , orientation: 'column' ,\
											componentList: ListBox {preferredSize: [260,150], left: 100, properties:{multiselect:false} align:'right'}, \
											st:StaticText {text:'', preferredSize:[280,0]},\
											applySkinTo: Group { orientation: 'row' , alignChildren: 'top',\
												rq: StaticText {text:'Aplicar máscara a:', align:'top'},\
													instanceRButton: Group { orientation: 'column', alignChildren: 'left', \
														allInstanceBtn : RadioButton {text: 'Estilo predeterminado', assignment: 'left'},\
														styleNameInstanceBtn: RadioButton {text: 'Nombre de estilo:'},\
													},\
													styleEditGroup: Group { orientation: 'column', alignChildren: 'left', \
														defaultStyleText: StaticText {text:'', preferredSize: [60,20],},\
														styleName: EditText { preferredSize: [90, 20], alignment: 'right'},\
													},\
												\
											},\
										},\
									}, \
						}, \
			 dividerLine: Panel { preferredSize: [280,1], margins:0,},\
             buttons: Group { orientation: 'row', \
                ok: Button { text: 'OK', properties:{name:'ok'} }, \
                cancel: Button { text: 'Cancelar', properties:{name:'cancel'} }, \
            } \
}";

/* Do some more dialog initializiations */

win = new Window (res);

win.text = "Nueva máscara Flex";

var lstbx = win.info.skinType.componentsGroup.componentList;
var styleNameControl = win.info.skinType.componentsGroup.applySkinTo.styleEditGroup.styleName;
var styleNameInstanceControl = win.info.skinType.componentsGroup.applySkinTo.instanceRButton.styleNameInstanceBtn;
var defaultStyleTextStaticControl = win.info.skinType.componentsGroup.applySkinTo.styleEditGroup.defaultStyleText;

var flexSkinPath;
var flexSkinComponentPath;
var aiTemplateName="máscaras_flex.ait";

if($.os.substring(0,3)=="Win")
{
	flexSkinPath = app.path.fullName + "/Cool Extras/"+ "es_ES" +"/Plantillas/MáscarasFlex";
	flexSkinComponentPath =  flexSkinPath + "/componentes";
	defaultStyleTextStaticControl.preferredSize = [60,15];
}
else
{
	flexSkinPath = app.path.fullName + "/Cool\ Extras.localized/" + "es_ES" + "/Plantillas/MáscarasFlex";
	flexSkinComponentPath = flexSkinPath + "/componentes";
}

var skinFolder = new Folder(  flexSkinComponentPath);

var files = skinFolder.getFiles();
for (i = 0; i < files.length; ++i)
{
	var fileName = files[i].name;
	var index = fileName.lastIndexOf(".ait");
	if(index != -1)
	{
		var onlyFileName = fileName.substring(0,index);
		lstbx.add("item",File.decode(onlyFileName));
	}
}


//Check the All components
win.info.skinType.rbtn1.value = true;

//disable the components group
win.info.skinType.componentsGroup.enabled = false;

//enable/diable style name group based on component selection
lstbx.onChange = enableStyleNameGroup;

//enable disable for skin Type
win.info.skinType.rbtn1.onClick = enableButtons;
win.info.skinType.rbtn2.onClick = enableButtons;

win.info.skinType.componentsGroup.applySkinTo.instanceRButton.allInstanceBtn.value = true;

//enable disable for Apply skin to
win.info.skinType.componentsGroup.applySkinTo.instanceRButton.allInstanceBtn.onClick = enableStyleNames;
styleNameInstanceControl.onClick = enableStyleNames;

enableButtons();


function enableButtons()
{
	win.info.skinType.componentsGroup.enabled = ! win.info.skinType.rbtn1.value;
	win.info.skinType.componentsGroup.applySkinTo.instanceRButton.allInstanceBtn.value = win.info.skinType.componentsGroup.enabled;
	
	if(lstbx.items.length > 0 && lstbx.selection == null)
		lstbx.selection = 0;

	enableStyleNameGroup();
}

function enableStyleNames()
{
	styleNameControl.enabled = styleNameInstanceControl.value;
}

function enableStyleNameGroup()
{
	win.info.skinType.componentsGroup.applySkinTo.enabled = (lstbx.selection != null) && (win.info.skinType.componentsGroup.enabled);
	enableStyleNames();
}

win.buttons.ok.onClick = function()
{
	var doc1;

	if(win.info.skinType.rbtn1.value)
	{
		//Open the Flex Skin template
			//alert(flexSkinPath + "/" + aiTemplateName);
		doc1 = app.open(new File(flexSkinPath + "/" + aiTemplateName));
		
	}
	else
	{
		var componentPath = flexSkinComponentPath + "/"+ lstbx.selection.text + ".ait";
		doc1 = app.open (new File(componentPath));
		
		//rename symbols if style name is given
		if(styleNameInstanceControl.value)
		{
			var styleName = styleNameControl.text;
			if(styleName.length > 0)
			{
				var symbolCount = doc1.symbols.length;
				for (i = 0; i < symbolCount; ++i)
				{
					var symbolName = doc1.symbols[i].name;
					var firstSeparator = symbolName.indexOf("_");
					var newSymbolName;
					if(firstSeparator != -1)
					{
						newSymbolName = symbolName.substring(0, firstSeparator) + "_" + styleName + symbolName.substring(firstSeparator, symbolName.length);
					}
					else //symbol name does not contain '_', add it to the last
					{
						newSymbolName = doc1.symbols[i].name + "_" + styleName;
					}
										
					if(newSymbolName.length > 63)
					{
						doc1.close(SaveOptions.DONOTSAVECHANGES);
						alert("No se puede crear un nombre de símbolo con más de 63 caracteres, asigne un \"Nombre de estilo\" más pequeño.");
						return;
					}
					
					doc1.symbols[i].name = newSymbolName;
				}
			}
		}
	}
	
	win.close(0);
}

// Click on Cancel button - cancel the operation

win.buttons.cancel.onClick = function()
{
	win.close(0);
}

win.center(); 
win.show();

